% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\docType{data}
\name{dax_model_3t}
\alias{dax_model_3t}
\title{DAX 3-state HMM}
\format{
An object of class \code{fHMM_model}.
}
\usage{
data(dax_model_3t)
}
\description{
A pre-computed HMM on closing prices of the DAX from 2000 to 2021
with three hidden states and state-dependent t-distributions for
demonstration purpose.
}
\details{
The model was derived via specifying
\preformatted{
controls <- list(
  states = 3,
  sdds   = "t",
  data   = list(file        = system.file("extdata", "dax.csv", package = "fHMM"),
                date_column = "Date",
                data_column = "Close",
                logreturns  = TRUE,
                from        = "2000-01-03",
                to          = "2021-12-31"),
  fit    = list("runs" = 100)
  )
}
}
\keyword{model}
