% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quants.R
\name{linearQuants}
\alias{linearQuants}
\title{Compute Quantiles using linear quantile regression (`quantreg` package) in
the Quantile Learning step.}
\usage{
linearQuants(
  data,
  A.root,
  ind,
  tau = c(0.001, seq(0.005, 0.995, by = 0.01), 0.999),
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} with data to be used for quantile
regression.}

\item{A.root}{A \code{logical(1L)} indicating whether the protected
attribute `A` is a root node of the causal graph. Used for splitting the
quantile regression.}

\item{ind}{A \code{logical} vector of length `nrow(data)`, indicating which
samples have the baseline value of the protected attribute.}

\item{tau, ...}{Forwarded to [quantreg::rq()].}
}
\value{
A `rqs` or a `quantregsplit` `S3` object, depending on the value of
the `A.root` argument.
}
\description{
Compute Quantiles using linear quantile regression (`quantreg` package) in
the Quantile Learning step.
}
