% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confusion_matrix.R
\name{confusion_matrix}
\alias{confusion_matrix}
\title{Confusion matrix}
\usage{
confusion_matrix(probs, observed, cutoff)
}
\arguments{
\item{probs}{numeric, vector with probabilities given by model}

\item{observed}{numeric, vector with actual values from outcome, either 0 or 1}

\item{cutoff}{numeric, single value denoting cutoff/threshold}
}
\value{
object of class \code{confussion_matrix}
It is a list with following fields:
\itemize{
\item{tp}{number of True Positives}
\item{fp}{number of False Positives}
\item{tn}{number of True Negatives}
\item{fn}{number of False Negatives}
}
}
\description{
Calculates confusion matrix for given cutoff
}
\examples{

probs <- rnorm(20, 0.4, 0.1)
observed <- round(runif(20))

confusion_matrix(probs, observed, 0.5)
}
