% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_bayesplot.R
\name{bayesplot}
\alias{bayesplot}
\title{bayesian convergence diagnosis plotting function}
\usage{
bayesplot(x, pars, plot, inc_warmup = FALSE)
}
\arguments{
\item{x}{returned object}

\item{pars}{Names of plotted parameters. They can be "theta", "alpha", "delta", "tau", or a subset of parameters. See vignette for fcirt for more details.}

\item{plot}{Types of plots.They can be "density", "trace", or "autocorrelation".}

\item{inc_warmup}{Whether to include warmup iterations or not when plotting. The default is FALSE.}
}
\value{
Selected plots for selected parameters
}
\description{
This function provides plots including density plots, trace plots, and auto-correlation plots to aid model convergence diagnosis.
}
\examples{
Data <- c(1)
Data <- matrix(Data,nrow = 1)
pairmap <- c(1,2)
pairmap <- matrix(pairmap,nrow = 1)
ind <- c(1,2)
ParInits <- c(1, 1, 1, -1, -1, -1)
ParInits <- matrix(ParInits, ncol = 3)
mod <- fcirt(fcirt.Data=Data,pairmap=pairmap,ind=ind,ParInits=ParInits,iter=3,warmup=1,chains=1)
bayesplot(mod, 'alpha', 'density', inc_warmup=FALSE)
}
