% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.ldata.R
\name{metric.ldata}
\alias{metric.ldata}
\alias{metric.mfdata}
\title{Distance Matrix Computation for ldata and mfdata class object}
\usage{
metric.ldata(
  ldata1,
  ldata2 = NULL,
  include = "all",
  exclude = "none",
  metric,
  par.metric = NULL,
  w,
  method = "none"
)
}
\arguments{
\item{ldata1}{List with  of fdata objects and a data.frame object calle 'df'.}

\item{ldata2}{List with  of fdata objects and a data.frame object calle 'df'.}

\item{include}{vector with the name of variables to use}

\item{exclude}{vector with the name of variables to not use}

\item{metric}{Type of metric to combine, if 'none', the function no combine and return a list o distances for each variable included}

\item{par.metric}{List of metric parameters for each variable included}

\item{w, }{weights to combine the metric (if metric is not 'none')}

\item{method}{The distance measure to be used. This must be one of
"euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".}
}
\description{
This function computes the distances between the list elements
}
\details{
This function returns a distance matrix by using \code{\link{metric.lp}}
function for \code{fdata} objects and  \code{\link{metric.dist}}
function for \code{vector} and \code{matric} objects. \cr
}
\examples{
\dontrun{
data(tecator)
names(tecator)[2]<-"df"
# Example 1 (list of distances)
ldist <- metric.ldata(tecator,method="none")
lapply(ldist,names)
# Example 2 (combined metric)
mdist <- metric.ldata(tecator,method="euclidean")
dim(mdist) 
}
}
\seealso{
See also \code{\link{dist}} for multivariate date case and
\code{\link{metric.lp} for functional data case}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manul.oviedo@usc.es}
}
\keyword{cluster}
