% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_table.R
\name{create_table}
\alias{create_table}
\title{Create Table}
\usage{
create_table(source, dec_pos = 2)
}
\arguments{
\item{source}{Vector, list or data frame input.  If the source is of class
list, it will be simplified to a vector using \code{unlist}.}

\item{dec_pos}{Number of positions to return in the frequency and cumulative
frequency variables.  Defaults to two positions following the decimal.}
}
\value{
A data frame containing the frequency distribution table.
If an error or warning occurs, a message will be printed to the console and
the function will return NULL.
}
\description{
\code{create_table} generates a frequency distribution table from a vector,
list or data frame input.
}
\details{
\code{create_table} returns a data frame that includes five variables:
group, count, frequency, cumulative count and cumulative frequency.
}
\examples{
source <- c(1, 1, 1, 1, 2, 2, 2, 3, 3, 4)
table <- create_table(source, dec_pos = 3)

}
