% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_frames.R
\name{random_data_frame}
\alias{random_data_frame}
\title{Generate a random data frame from given configuration}
\usage{
random_data_frame(configuration, size)
}
\arguments{
\item{configuration}{list, a configuration of columns with
all arguments required by vector generator passed as
sublists of sublist "columns". Column can be also generated with custom function.
Pass "custom_column" as column type and function (or function name) as custom_column_generator.
Column generator has to accept argument size and return a vector of this size.
Third option is to pass an expression that involves existing columns. This can be a simple one,
or a call of an existing function.}

\item{size}{integer, number of rows to generate.}
}
\value{
data.frame
}
\description{
Generate a random data frame from given configuration
}
\examples{
conf <- list(
 columns = list(
   first_column = list(
     type = "string",
     length = 3
   ),
   second_column = list(
     type = "integer",
     max = 10
   ),
   third_column = list(
     type = "calculated",
     formula = "second_column * 2"
   )
 )
)

random_data_frame(conf, size = 10)
}
