% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.flexsurvmix.R
\name{ajfit}
\alias{ajfit}
\title{Aalen-Johansen nonparametric estimates comparable to a fitted flexsurvmix
model}
\usage{
ajfit(x, newdata = NULL, tidy = TRUE)
}
\arguments{
\item{x}{Fitted model returned by \code{\link{flexsurvmix}}.}

\item{newdata}{Data frame of alternative covariate values to check fit for.
Only factor covariates are supported.}

\item{tidy}{If \code{TRUE} then a single tidy data frame is returned.
Otherwise the function returns the object returned by \code{survfit}, or a
list of these objects if we are computing subset-specific estimates.}
}
\description{
Given a fitted flexsurvmix model, return the Aalen-Johansen estimates of the
probability of occupying each state at a series of times covering the
observed data.  State 1 represents not having experienced any of the
competing events, while state 2 and any further states correspond to having
experienced each of the competing events respectively.  These estimates can
be compared with the fitted probabilities returned by
\code{\link{p_flexsurvmix}} to check the fit of a \code{flexsurvmix} model.
}
\details{
This is only supported for models with no covariates or models containing
only factor covariates.

For models with factor covariates, the Aalen-Johansen estimates are computed
for the subsets of the data defined in \code{newdata}.  If \code{newdata} is
not supplied, then this function returns state occupancy probabilities for
all possible combinations of the factor levels.

The Aalen-Johansen estimates are computed using
\code{\link[survival]{survfit}} from the \code{survival} package (Therneau
2020).
}
\references{
Therneau T (2020). _A Package for Survival Analysis in R_. R
  package version 3.2-3, <URL: https://CRAN.R-project.org/package=survival>.
}
