% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/homogeneity_test.R
\name{xiAnova}
\alias{xiAnova}
\title{Homogeneity test for the shape}
\usage{
xiAnova(x, leftrim = 0, rightrim = 1)
}
\arguments{
\item{x}{matrix of observations (rows: observations, d columns: stations).}

\item{leftrim}{integer indicating lower trimming parameter (\eqn{\ge 0}).}

\item{rightrim}{integer indicating upper trimming parameter (\eqn{\ge 0}).}
}
\value{
p-value of the test.
}
\description{
A test for assumption \eqn{H_0}: "shape parameter is equal for all d GEV margins"
with test statistic based on (trimmed) L-moments.
}
\examples{
library("evd")
# sample observations of 100 years at 5 stations:
set.seed(1053)
x19 <- matrix(rgev(400, 2, 1, 0.1), ncol=4) # 4 stations with the same shape
x10 <- rgev(100, 2, 1, 0.4) # one station with a different shape
x <- cbind(x19, x10)
xiAnova(x=x, leftrim=0, rightrim=1)
}

