% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navbarPage.R
\name{navbar_page}
\alias{navbar_page}
\title{Fomantic UI page with top level navigation bar}
\usage{
navbar_page(
  ...,
  title = "",
  id = NULL,
  selected = NULL,
  position = c("", "top fixed", "bottom fixed"),
  head = NULL,
  header = NULL,
  footer = NULL,
  collapsible = FALSE,
  window_title = title,
  class = "stackable",
  theme = NULL,
  enable_hash_state = TRUE,
  suppress_bootstrap = TRUE
)
}
\arguments{
\item{...}{Other arguments to be added as attributes of the main div tag wrapper (e.g. style, class etc.)}

\item{title}{A title to display in the navbar.}

\item{id}{ID of the navbar menu. Given random ID if none specified.}

\item{selected}{Which tab should be selected first? If none selected, will automatically have the first tab open.}

\item{position}{Determines the location and behaviour of the navbar. Padding will be included when pinned to prevent
overlap.
\itemize{
\item{""}{Default. Top of page, and goes out of view when scrolling}
\item{"top fixed"}{Top of page, pinned when scrolling}
\item{"bottom fixed"}{Bottom of page, pinned when scrolling}
}}

\item{head}{Optional list of tags to be added to \code{tags$head}.}

\item{header}{Optional list of tags to be added to the top of all \code{tab_panel}s.}

\item{footer}{Optional list of tags to be added to the bottom of all \code{tab_panel}s.}

\item{collapsible}{\code{TRUE} to automatically collapse the navigation elements into a menu when the width of the
browser is less than 768 pixels (useful for viewing on smaller touchscreen device)}

\item{window_title}{A title to display in the browser's title bar. By default it will be the same as the navbar
title.}

\item{class}{Additional classes to be given to the navbar menu. Defaults to \code{"stackable"}. For optional classes
have a look in details}

\item{theme}{Theme name or path. Full list of supported themes you will find in
\code{SUPPORTED_THEMES} or at https://semantic-ui-forest.com/themes.}

\item{enable_hash_state}{boolean flag that enables a different hash in the URL for each tab, and creates historical
events}

\item{suppress_bootstrap}{boolean flag that suppresses bootstrap when turned on}
}
\value{
A \code{shiny.tag.list} containing the UI for a shiny application.
}
\description{
This creates a Fomantic page for use in a Shiny app. It is in the same layout as \code{\link[shiny]{navbarPage}},
where a top level navigation bar exists.
}
\details{
Inside, it uses two crucial options:

(1) \code{shiny.minified} with a logical value, tells whether it should attach min or full
semantic css or js (TRUE by default).
(2) \code{shiny.custom.semantic} if this option has not NULL character \code{semanticPage}
takes dependencies from custom css and js files specified in this path
(NULL by default). Depending on \code{shiny.minified} value the folder should contain
either "min" or standard version. The folder should contain: \code{semantic.css} and
\code{semantic.js} files, or \code{semantic.min.css} and \code{semantic.min.js}
in \code{shiny.minified = TRUE} mode.

The following classes can be applied to the navbar:
\itemize{
\item{\code{stackable}} - When the width of the webpage becomes too thin, for example on mobile, the navbar will
become a stack
\item{\code{inverted}} - Will create an inverted coloured navbar
}
}
\examples{
navbar_page(
  title = "App Title",
  tab_panel("Plot"),
  tab_panel("Summary"),
  tab_panel("Table")
)

navbar_page(
  title = "App Title",
  tab_panel("Plot"),
  tab_panel("Icon", icon = "r project"),
  navbar_menu(
    "More",
    tab_panel("Summary"),
    "----",
    "Section header",
    tab_panel("Table")
  )
)

}
