% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bio.volume.R
\name{bio.volume}
\alias{bio.volume}
\title{Biovolume calculus}
\usage{
bio.volume(data, pco = 0.76, genus = NULL, model = NULL)
}
\arguments{
\item{data}{a numeric vector or data frame with size data.
Size data parameters by model see \code{\link{volume}} details.}

\item{pco}{(optional) vector informing percent of cell occupancy in the test.
Default value set for specific genus in \code{\link{data_pco}}.}

\item{genus}{(optional) character informing foraminifera genus to calculate individual biovolume.
See all genera available in \code{\link{data_pco}}}

\item{model}{(optional if genus unknown) character informing geometric model to calculate volume.
See all models available in \code{\link{volume.total}}}
}
\value{
A `data.frame` or numeric object, consisting of calculated individual volume (if not available), biovolume and model (if \code{genus} is informed).
}
\description{
This function calculates Foraminifera biovolume, through geometric approximation.
To compute others organisms cell volume use \code{\link{volume.total}} function
}
\details{
The function calculates the biovolume of different individuals from the available genera.
}
\examples{
# Calculate biovolume for different genera
#Ammonia size data
data("ammonia")

bio.volume(ammonia, genus= "ammonia")

# Calculate biovolume for unknown genus
df <- data.frame(h = 10, d_one = 10,
d_two = 10, area = 10, width = 10, length = 10)
bio.volume(df, model = "10hl", pco = 0.76)

}
\seealso{
\code{\link{volume.total}}

\code{\link{biomass}}

\code{\link{measure}}
}
\author{
Thaise R. Freitas \email{thaisericardo.freitas@gmail.com}
}
