% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata_rkhs.R
\name{fdata_rkhs}
\alias{fdata_rkhs}
\title{functional data in rkhs}
\usage{
fdata_rkhs(curves, rk, gamma = 1e-05)
}
\arguments{
\item{curves}{a data matrix with observations (curves) in rows and the
discretizations points in columns.}

\item{rk}{kernek function rk object.}

\item{gamma}{regularization parameter. Defaoult value = 1e-5.}
}
\value{
\item{data}{input curves.} \item{fdata}{smoothed curves.}
\item{lambda}{coefficients of the (stable) and d dimensional RKHS
representation.} \item{alpha}{coefficients of the RKHS expansion.}
\item{gamma}{regularization parameter.}
}
\description{
Representing functinal data using Reproducing Kernel Hilbert Spaces.
Approximate each curve with a smooth function using a kernel function.
}
\details{
With this function each function can be represented with a vector in R^d.
}
\examples{

t = 1:50
curves = matrix(sin(t)+rnorm(length(t)),nrow=1)
f.data <- fdata_rkhs(curves, rk = rk(t,sigma = 0.01))
plot(t,curves, xlab='time', ylab='PM10 dataset', col='gray', lty=1, type='b')
lines(t,f.data$fdata, col='blue', lty=1)

}
\references{
A. Muñoz, J. González, Representing functional data using
support vector machines, Pattern Recognition Letters 31 (2010) 511–516. <doi:10.1016/j.patrec.2009.07.014>.
}
\author{
N. Hernández and J. Cugliari
}
