% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_of_spills_methods.R
\name{plotPairwise.list_of_spills}
\alias{plotPairwise.list_of_spills}
\title{Function to plot pairwise spillovers}
\usage{
\method{plotPairwise}{list_of_spills}(
  spillover_table,
  within = F,
  which = 1:ncol(utils::combn(nrow(spillover_table$list_of_tables[[1]]$tables[[1]]),
    2)),
  ...
)
}
\arguments{
\item{spillover_table}{a list_of_spills object, ideally from rolling window estimation}

\item{within}{whether to compute the within spillovers if the spillover
tables are frequency based.}

\item{which}{a vector with indices specifying which plots to plot.}

\item{...}{for the sake of CRAN not to complain}
}
\value{
a plot of pairwise spillovers
}
\description{
Taking in list_of_spillovers, the function plots the pairwise spillovers
using the zoo::plot.zoo function
}
\author{
Tomas Krehlik <tomas.krehlik@gmail.com>
}
