% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wipe_clean.R
\name{wipe_clean}
\alias{wipe_clean}
\title{Remove All Objects From an Environment}
\usage{
wipe_clean(environment = getOption("wipe_clean_environment"), all_names = TRUE)
}
\arguments{
\item{environment}{The environment that should be wiped clean.
Defaults to \code{\link{.GlobalEnv}}.}

\item{all_names}{See argument \code{all.names} for \code{\link{ls}}.}
}
\value{
A character vector containing the names of objects removed, but
called for its side effect of removing all objects from the environment.
}
\description{
Wipe an environment, typically \code{\link{.GlobalEnv}}, clean.
}
\examples{
an_object <- 1
wipe_clean()
ls()
e <- new.env()
assign("a", 1, envir = e)
assign("b", 1, envir = e)
ls(envir = e)
wipe_clean(envir = e)
ls(envir = e)
RUnit::checkIdentical(length(ls(envir = e)), 0L)
}
\seealso{
Other R memory functions: 
\code{\link{memory_hogs}()}
}
\concept{R memory functions}
