% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_id.R
\name{id_adj}
\alias{id_adj}
\title{Simple adjustment}
\usage{
id_adj(rate, lsize = 6, csize = 3)
}
\arguments{
\item{rate}{ID rate vector.}

\item{lsize}{Lineup size. Defaults to 6.}

\item{csize}{Number of confidence levels. Defaults to 3.}
}
\value{
Adjusted ID vector.
}
\description{
A function to adjust the id rates for ca lineups using the 1/(lineup size) method;
is applicable to ordered id rates with the same confidence levels for all responses.
}
\examples{
ca_id <- c(rep(0,3), rep(c(0.1, 0.15, 0.25), 2))
id_adj(ca_id)

## change line size to 5
id_adj(ca_id, lsize = 5)

## For multiple groups
ca_id2 <- c(c(rep(0,3), rep(c(0.1, 0.15, 0.25), 2)),
            c(rep(0,3), rep(c(0.1, 0.2, 0.3), 2)) )
group <- rep(c("a", "b"), each = 9)
## Adjust id rates by groups
by(ca_id2, group, id_adj)

}
