% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{fboot_plot}
\alias{fboot_plot}
\title{Plot the robustness of a functional clustering
 evaluated by bootstrapping from 1 to (all-1) observations}
\usage{
fboot_plot(fres, lboot, main = "", opt.crit = "Jaccard",
           opt.var  = c("assemblages", "performances"))
}
\arguments{
\item{fres}{an object resulting from a functional clustering
obtained using the function \code{\link{fclust}}.}

\item{lboot}{an object resulting from a functional clustering
obtained using the function \code{\link{fclust}}.}

\item{main}{a string, used as main title for all plots.}

\item{opt.crit}{an object resulting from a functional clustering
obtained using the function \code{\link{fclust}}.}

\item{opt.var}{an object resulting from a functional clustering
obtained using the function \code{\link{fclust}}.}
}
\value{
a list of lists, each containing a matrix by clustering index.
}
\description{
Evaluate by bootstrapping
the robustness of a functional clustering
to perturbations of data. The perturbed data can be
the number of assemblages taken into account,
or the number of performances taken into account.
}
\details{
The trees obtained by bootstrapping of performances to omit
 are compared to the reference tree obtained with all components
 using different criteria :
 "Czekanowski_Dice", "Folkes_Mallows", "Jaccard", "Kulczynski",
 "Precision", "Rand", "Recall", "Rogers_Tanimoto", "Russel_Rao",
 "Sokal_Sneath1" and "Sokal_Sneath2" index.
 For more informations, see the notice of R-package \code{clusterCrit}.
}
\examples{

# Plot the significance of each component within each components cluster

layout(matrix(c(1,2,3,4), nrow = 2, ncol = 2, byrow = TRUE))
fboot_plot(fres  = CedarCreek.2004.2006.res,
           lboot = CedarCreek.2004.2006.boot.assemblages,
           main  = "BioDIV2",
           opt.var = "assemblages", opt.crit = "Jaccard")
layout(1)


}
\references{
Package "clusterCrit": Clustering Indices,
  by Bernard Desgraupes (University of Paris Ouest - Lab Modal'X)
}
