% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_components_box}
\alias{plot_components_box}
\title{Plot mean performances of assemblages
that contain a given component}
\usage{
plot_components_box(fobs, mOccur, sres,
                    ordre = NULL, ylim = range(fobs),
                    elt.wdw = seq_len(dim(mOccur)[2]),
                    main     = "",
                    pvalue   = fpvalue(),
                    opt.mean = "amean", opt.hor = TRUE  )
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{sres}{a table generated by the function \code{\link{sort_motifs}}.
The table contains statistical properties of assembly motifs,
sorted by increasing or decreasing mean performances.}

\item{ordre}{an integer vector of \code{length(fobs)}.
The vector contains labels for each assemblages,
that determine the order for assembly motifs.}

\item{ylim}{a vector of two numerics.
The numerics are extrem values of performance \code{y-axis}.}

\item{elt.wdw}{a vector of integers.
It indicates the components to plot.}

\item{main}{a string. The string is used as graph title.}

\item{pvalue}{a probability,
used as threshold
in the variance analysis. Then \code{pvalue} must be
higher than \code{0} and lower than \code{1}.
Groups significantly different
(at a p-value < \code{pvalue}) are then indicated by differents letters
on the right of boxplots.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switch to arithmetic formula if \code{opt.mean = "amean"}.
Switch to geometric formula if \code{opt.mean = "gmean"}.}

\item{opt.hor}{a logical.
If \code{opt.hor = TRUE},
boxplot is plotted as horizontal boxes
alongside a vertical y-axis of performances.
If \code{opt.hor = FALSE},
boxplot is plotted as vertical boxes
alongside a horizontal y-axis of performances.}
}
\value{
Nothing. It is a procedure.
}
\description{
Plot performances of assemblages
that contain a given component
as boxplots,
possibly horizontally or vertically,
by decreasing or increasing values
or in the same order as the tree clustering.
}
\details{
None.
}
\keyword{internal}
