% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{plot_prediction_simple}
\alias{plot_prediction_simple}
\title{Plot Simulated or Predicted \emph{vs} Observed performances}
\usage{
plot_prediction_simple(Fx, Fy,
                       assMotif = rep(1, length(Fx)),
                       xylab     = c("Observed performance",
                                     "Modelled performance"),
                       xylim     = range(Fx),
                       figs      = rep(fsymbols()[1], length(Fx)),
                       cols      = rep(fcolours()[1], length(Fx)),
                       nbcl      = 1,
                       main      = "",
                       opt.mean  = "amean",
                       pvalue    = fpvalue())
}
\arguments{
\item{Fx, Fy}{two numeric vector of \code{length(Fx)}.
The first vector contains assemblage performances to plot on x-axis.
The second vector contains assemblage performances to plot on y-axis.}

\item{assMotif}{an integer vector of \code{length(Fx)}.
The vector contains the labels of each assemblages.
The labels are only used to plot the assemblage performances
that share a same assembly motif
with a same symbol and color.
If it is omitted, all points are plotted using a same symbol and color.
The default symbol and color is \code{"red circle"}.}

\item{xylab}{a vector of two strings.
The strings are the labels of \code{(x,y)} axis.}

\item{xylim}{a vector of two numerics.
The numerics are extrem values of \code{(x,y)} axis.}

\item{figs, cols}{two integer vectors of \code{length(Fx)}.
They contain the symbols and colours specific to each assembly motif
recorded in \code{assMotif}.}

\item{nbcl}{an integer.
The integer indicates the number of clusters of components.
The theoretical number \code{m} of assembly motif
is \code{m = 2^nbcl - 1}.
The number of clusters of components is only used
as information written on the graph.}

\item{main}{a string. The string is used as graph title.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switch to arithmetic formula if \code{opt.mean = "amean"}.
Switch to geometric formula if \code{opt.mean = "gmean"}.}

\item{pvalue}{a probability,
used as threshold
in the variance analysis. Then \code{pvalue} must be
higher than \code{0} and lower than \code{1}.
Groups significantly different
(at a p-value < \code{pvalue}) are then indicated by differents letters
on the right of boxplots.}
}
\value{
Nothing. It is a procedure.
}
\description{
Take two vectors
corresponding to assemblage performances
modelled by component clustering model,
or assemblage performances predicted by cross-validation,
and reference, observed assemblage performances,
then plot modelled assemblage performances
\emph{versus} observed assemblage performances.
}
\details{
All options are default values. If all options are omitted,
the function plot \code{Fy} \emph{vs} \code{Fx}, in red circle,
with labels of x-axis \code{xlab = "Observed performances"} and
               y-axis \code{ylab = "Simulated performances"}. \cr

The two dashed blue lines are \code{mean(Fy)} and \code{mean(Fx)}.
}
\keyword{internal}
