% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects.R
\name{get_project_walkthroughs}
\alias{get_project_walkthroughs}
\title{Retrieve Highbond Project - Walkthroughs / Execute Procedures}
\usage{
get_project_walkthroughs(
  auth,
  walkthrough_id,
  fields = NULL,
  pagesize = 50,
  waittime = 0.2
)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{walkthrough_id}{Will get only one.}

\item{fields}{OPTIONAL. A character vector each field requested within the
project. NULL will default to all fields.}

\item{pagesize}{Defaults to 50. Maximum is 100.}

\item{waittime}{Time in seconds to wait between requests.}
}
\value{
A tibble of walkthroughs
}
\description{
"A walkthrough is a series of steps you perform to establish the
reliability of controls and test the design of controls. Each control you
define has a corresponding walkthrough that is used to verify that the
control is designed appropriately. In a Workplan workflow project, a
walkthrough is called an execute procedure."
}
