% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.cmod.R
\name{eval.cmod}
\alias{eval.cmod}
\title{Evaluate covariance or semivariance model.}
\usage{
eval.cmod(mod, d, coords = NULL)
}
\arguments{
\item{mod}{A covariance or semivariance model.}

\item{d}{An \eqn{n \times m} matrix of distances.}

\item{coords}{Not used.}
}
\value{
Returns the evaluated model with necessary
  components needed for \code{\link[gear]{estimate}} and
  \code{\link{predict}}.
}
\description{
\code{eval.cmod} evaluates the covariance 
of a model based on the provided arguments.  This
function will be deprecated in the future. Please use
the \code{\link[gear]{evaluate}} function.
}
\examples{
n = 10
coords = matrix(runif(2*n), nrow = n, ncol = 2)
d = as.matrix(dist(coords))
cmod = cmod_std(model = "exponential", psill = 1, r = 1)
eval.cmod(cmod, d)
}
\author{
Joshua French
}
