% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geardf-plot.R
\name{plot.geardf}
\alias{plot.geardf}
\title{Plot \code{geardf} object}
\usage{
\method{plot}{geardf}(x, zcol = names(x), interp = FALSE, common.legend = FALSE, ...)
}
\arguments{
\item{x}{A \code{geardf} object produced by the
\code{\link[gear]{geardf}} or \code{predict.geolm*}
functions.}

\item{zcol}{The names of the columns of \code{x} to plot.
The coordinate columns are automatically stripped from
\code{zcol}.}

\item{interp}{A logical value indicating whether the
values should be interpolated onto a grid. If
\code{FALSE}, then the
\code{\link[autoimage]{autopoints}} function is used to
construct a heated scatterplot. If \code{TRUE}, then
the \code{\link[autoimage]{autoimage}} function is used
to create a heat map. The default is \code{FALSE}.}

\item{common.legend}{A logical value indicating whether a
common legend should be used for the
scatterplots/images. The default is \code{FALSE}.}

\item{...}{Additional arguments to passed to the
\code{\link[autoimage]{autopoints}} or
\code{\link[autoimage]{autoimage}} functions.}
}
\description{
Plot a \code{geardf} object produced by the
\code{\link[gear]{geardf}} or \code{predict.geolm*}
functions. See the \code{\link[autoimage]{autopoints}}
and \code{\link[autoimage]{autoimage}} functions for
advanced options.
}
\examples{
data(toydata)
# newdata must have columns with prediction coordinates
newdata = data.frame(x1 = runif(10), x2 = runif(10))

# specify a standard covariance model
mod = cmod_std(model = "exponential", psill = 1, r = 1)

# geolm for universal kriging
geolm_uk = geolm(y ~ x1 + x2, data = toydata, mod = mod,
             coordnames = c("x1", "x2"))

# prediction for universal kriging
pred_uk = predict(geolm_uk, newdata, return_type = "geardf")
# heated scatterplot
plot(pred_uk)
# interpolated image of results
plot(pred_uk, interp = TRUE)
# plot only predictions and rmspe with different colors
plot(pred_uk, c("pred", "rmspe"), col = cm.colors(5))
#'plot only predictions with coarser interpolation grid
plot(pred_uk, "pred", interp = TRUE,
     interp.args = list(no.X = 10, no.Y = 10))
}
\seealso{
\code{\link[autoimage]{autopoints}},
  \code{\link[autoimage]{autoimage}}
}
\author{
Joshua French
}
