% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genKEGG.R
\name{genKEGG}
\alias{genKEGG}
\title{Gene enrichment of KEGG analysis}
\usage{
genKEGG(
  id,
  group_list = NULL,
  org,
  use_symbol = TRUE,
  pAdjustMethod = "BH",
  pvalueCutoff = 0.05,
  qvalueCutoff = 0.1,
  minGSSize = 10,
  maxGSSize = 500,
  universe,
  ...
)
}
\arguments{
\item{id}{A vector of entrez gene.}

\item{group_list}{A list of gene id groups, default is NULL.}

\item{org}{KEGG organism name from `keggOrg_name`.}

\item{use_symbol}{Logical to set result gene id as gene symbol, default is TRUE.}

\item{pAdjustMethod}{One of "holm", "hochberg", "hommel", "bonferroni", "BH",
"BY", "fdr", "none".}

\item{pvalueCutoff}{Numberic of adjusted pvalue cutoff, default is 0.05.}

\item{qvalueCutoff}{Numberic of adjusted pvalue cutoff, default is 0.1.}

\item{minGSSize}{Numberic of minimal size of each geneSet for analyzing,
default is 10.}

\item{maxGSSize}{Numberic of maximal size of each geneSet for analyzing,
default is 500.}

\item{universe}{Background genes. If missing, the orgdb all gene list will be
used as background.}

\item{...}{Other argument to `enrichKEGG` function}
}
\value{
A `data.frame`.
}
\description{
Gene enrichment of KEGG analysis
}
\examples{
\dontrun{
# only gene ids
data(geneList, package = "genekitr")
id <- names(geneList)[1:100]
keg <- genKEGG(id, org = "human")

# gene id with groups
id <- c(head(names(geneList),50),tail(names(geneList),50))
group <- list(group1  = c(rep('up',50),rep('down',50)),
              group2 = c(rep('A',40),rep('B',60)))
gkeg <- genKEGG(id, group_list = group,
              org = "human", pvalueCutoff = 0.1,
              qvalueCutoff = 0.1, use_symbol = FALSE
)

}

}
