% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CO.R
\name{CO}
\alias{CO}
\title{Where crossovers occur per individual with 2 ways to deal with
missing data}
\usage{
CO(indata, naive = FALSE)
}
\arguments{
\item{indata}{this is a binary coded genotype data frame from a genotypeR object (see example below).}

\item{naive}{this takes 2 values: 1) FALSE (default) returns
list with COs distributed by marker distance, and 2) TRUE returns a
list with COs without regard to marker distance (i.e., at the final
non-missing data point in a string of missing genotypes)}
}
\value{
list of COs counted per individual
}
\description{
\code{CO} is an internal function used in \code{count_CO} to count
crossovers. \code{CO} is provided in case there is a use case for
the user. We used this function for QA and it can be used for
estimates of crossover assurance.
}
\examples{

library(doBy)
data(genotypes_data)
data(markers)
## genotype table
marker_names <- make_marker_names(markers)
GT_table <- Ref_Alt_Table(marker_names)
## remove those markers that did not work
genotypes_data_filtered <- genotypes_data[,c(1, 2, grep("TRUE",
colnames(genotypes_data)\%in\%GT_table$marker_names))]

warnings_out2NA <- initialize_genotypeR_data(seq_data = genotypes_data_filtered,
genotype_table = GT_table, output = "warnings2NA")
binary_coding_genotypes <- binary_coding(warnings_out2NA, genotype_table = GT_table)
chr2 <- subsetChromosome(binary_coding_genotypes, chromosome="chr2")
to_count_CO <- binary_genotypes(chr2)
counted_per_individuals <- lapply(splitBy(~SAMPLE_NAME+WELL, data=to_count_CO), CO)

}
\keyword{count}
\keyword{crossovers}
\keyword{genotypeR}
