% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_horizon.R, R/stat_horizon.R
\docType{data}
\name{geom_horizon}
\alias{geom_horizon}
\alias{GeomHorizon}
\alias{stat_horizon}
\title{Horizon plots}
\usage{
geom_horizon(
  mapping = NULL,
  data = NULL,
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  origin = "midpoint",
  horizonscale = 6,
  rm.outliers = FALSE,
  reverse = FALSE,
  mirror = FALSE,
  inherit.aes = TRUE
)

stat_horizon(
  mapping = NULL,
  data = NULL,
  geom = "ribbon",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = TRUE,
  inherit.aes = TRUE,
  origin = "midpoint",
  horizonscale = 6,
  rm.outliers = FALSE,
  reverse = FALSE,
  mirror = FALSE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{origin}{Origin of the horizon plot. It can either be a string, namely
\code{"midpoint"} (the default), \code{"median"},
\code{"mean"}, \code{"min"} or \code{"quantiles"}, or a user-specified number.}

\item{horizonscale}{Cutpoints of the horizon plot. It can either be an integer
specifying the number of ranges (default is \code{6}),
or a user-supplied numeric vector with the cutpoints defining the different ranges.}

\item{rm.outliers}{If \code{TRUE}, all the values below \code{quantile(y, 0.25)-1.5*IQR(y)}
and above \code{quantile(y, 0.75)+1.5*IQR(y)} are excluded from the origin and cutpoint
calculations (default is \code{FALSE}). @param reverse If \code{TRUE}, the horizon peaks
for the values below the origin are reversed (default is \code{FALSE}).}

\item{reverse}{IF \code{TRUE}, the horizon peaks for all the values below the origin
are reversed (default is \code{FALSE}).}

\item{mirror}{If \code{TRUE}, the horizon peaks for all the values are reversed
(default is \code{FALSE}).}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{geom}{Used geom, default to 'ribbon'}
}
\value{
'ggplot2' layer for building a horizon plot.
}
\description{
This function builds horizon plots in ggplot2. It allows for the
customization of the origin and the horizon scale.
}
\details{
A horizon plot is a special type of area plot in which the original data
is transformed based on an origin and a horizon scale. The data is cut in
different intervals, and the further the data is from the origin, the deeper
its color usually is. All the intervals above the origin are then stacked on
top of one another, keeping the intervals closest to the origin in the bottom
and the furthest away ones on top. Likewise, the intervals below the origin
are normally given a different color palette and they are stacked in a similar
manner in the same area as the intervals above the origin. You can learn more
about how horizon plots are built in \code{vignette('ggHoriPlot')} or at
\url{https://bernatgel.github.io/karyoploter_tutorial/Tutorial/PlotHorizon/PlotHorizon.html}.
}
\section{Orientation}{
 
This geom treats each axis differently and, thus, can thus have two orientations. Often the orientation is easy to deduce from a combination of the given mappings and the types of positional scales in use. Thus, ggplot2 will by default try to guess which orientation the layer should have. Under rare circumstances, the orientation is ambiguous and guessing may fail. In that case the orientation can be specified directly using the \code{orientation} parameter, which can be either \code{"x"} or \code{"y"}. The value gives the axis that the geom should run along, \code{"x"} being the default orientation you would expect for the geom.
}

\section{Aesthetics}{

\code{geom_horizon()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{xend}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
}
}

\examples{
# Generate data
huron <- data.frame(year = 1875:1972, level = as.vector(LakeHuron))

# Basic plot with default colors
h <- ggplot(huron) + geom_horizon(aes(year, level))

# Add color scheme
h + theme_void() + scale_fill_hcl()

# Add cupoints
ggplot(huron) +
  geom_horizon(aes(year, level, fill = ..Cutpoints..)) +
  theme_void() +
  scale_fill_hcl()


}
\keyword{datasets}
