% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{likelihood}
\alias{likelihood}
\title{Calculate log likelihoods}
\usage{
likelihood(pvector, data, min_lik = 1e-10)
}
\arguments{
\item{pvector}{a parameter vector}

\item{data}{data model instance}

\item{min_lik}{minimal likelihood.}
}
\value{
a vector
}
\description{
These function calculate log likelihoods. \code{likelihood_rd} implements
the equations in Voss, Rothermund, and Voss (2004). These equations
calculate diffusion decision model (Ratcliff & Mckoon, 2008). Specifically,
this function implements Voss, Rothermund, and Voss's (2004) equations A1
to A4 (page 1217) in C++.
}
\examples{
model <- BuildModel(
p.map     = list(A = "1", B = "1", t0 = "1", mean_v = "M", sd_v = "1",
            st0 = "1"),
match.map = list(M = list(s1 = 1, s2 = 2)),
factors   = list(S = c("s1", "s2")),
constants = c(st0 = 0, sd_v = 1),
responses = c("r1", "r2"),
type      = "norm")

p.vector <- c(A = .25, B = .35,  t0 = .2, mean_v.true = 1, mean_v.false = .25)
dat <- simulate(model, 1e3,  ps = p.vector)
dmi <- BuildDMI(dat, model)
den <- likelihood(p.vector, dmi)

model <- BuildModel(
p.map     = list(a = "1", v = "1", z = "1", d = "1", t0 = "1", sv = "1",
            sz = "1", st0 = "1"),
constants = c(st0 = 0, d = 0),
match.map = list(M = list(s1 = "r1", s2 = "r2")),
factors   = list(S = c("s1", "s2")),
responses = c("r1", "r2"),
type      = "rd")

p.vector <- c(a = 1, v = 1, z = 0.5, sz = 0.25, sv = 0.2, t0 = .15)
dat <- simulate(model, 1e2, ps = p.vector)
dmi <- BuildDMI(dat, model)
den <- likelihood (p.vector, dmi)

}
\references{
Voss, A., Rothermund, K., & Voss, J. (2004).  Interpreting the
parameters of the diffusion model: An empirical validation.
\emph{Memory & Cognition}, \bold{32(7)}, 1206-1220. \cr\cr
Ratcliff, R. (1978). A theory of memory retrival. \emph{Psychological
Review}, \bold{85}, 238-255.
}
