% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.loop.R
\name{aes_loop}
\alias{aes_loop}
\title{Create a list of grouped aesthetic mappings.}
\usage{
aes_loop(x, y, ...)
}
\arguments{
\item{x, y, ...}{A vector of variable names. Vector can consist of a
combination of \code{dplyr}-like symbols (unqouted names) and
\code{numerics/integers} referencing the variable position within
\code{data}.}
}
\value{
\code{aes_loop()} returns an environment that includes \code{aes.list} (the
list of grouped aesthetic mappings used inside \code{ggloop()}) and a few
vectors used by other functions and \code{lapply()} loops for control (to
eliminate running duplicate code to return a result from a previously ran
function).

\code{aes_loop2()} returns a list of grouped mappings. This is similar to a
bunch of \code{aes()} mappings in a list waiting to be passed to
\code{ggplot()}.
}
\description{
\code{aes_loop} cannot be used affectively outside of \code{ggloop()} (or at
least with access to the data frame names).
}
\details{
\code{aes_loop()} is solely meant to be called within
\code{ggloop()}. To create the raw list of grouped mappings, set
\code{ggloop()}'s \code{gg_obs} argument to \code{FALSE}.
}

