% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-rect.R, R/geom-bar.R, R/geom-bin2d.R,
%   R/geom-boxplot.R, R/geom-col.R, R/geom-crossbar.R, R/geom-ribbon.R,
%   R/geom-density.R, R/geom-polygon.R, R/geom-map.R, R/geom-sf.R,
%   R/geom-tile.R, R/geom-violin.R
\name{geom_rect_pattern}
\alias{geom_rect_pattern}
\alias{geom_bar_pattern}
\alias{geom_histogram_pattern}
\alias{geom_bin2d_pattern}
\alias{geom_boxplot_pattern}
\alias{geom_col_pattern}
\alias{geom_crossbar_pattern}
\alias{geom_ribbon_pattern}
\alias{geom_area_pattern}
\alias{geom_density_pattern}
\alias{geom_polygon_pattern}
\alias{geom_map_pattern}
\alias{geom_sf_pattern}
\alias{geom_tile_pattern}
\alias{geom_violin_pattern}
\title{ggplot2 geoms with support for pattern fills}
\usage{
geom_rect_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_bar_pattern(
  mapping = NULL,
  data = NULL,
  stat = "count",
  position = "stack",
  ...,
  width = NULL,
  binwidth = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_histogram_pattern(
  mapping = NULL,
  data = NULL,
  stat = "bin",
  position = "stack",
  ...,
  binwidth = NULL,
  bins = NULL,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_bin2d_pattern(
  mapping = NULL,
  data = NULL,
  stat = "bin2d",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_boxplot_pattern(
  mapping = NULL,
  data = NULL,
  stat = "boxplot",
  position = "dodge2",
  ...,
  outlier.colour = NULL,
  outlier.color = NULL,
  outlier.fill = NULL,
  outlier.shape = 19,
  outlier.size = 1.5,
  outlier.stroke = 0.5,
  outlier.alpha = NULL,
  notch = FALSE,
  notchwidth = 0.5,
  varwidth = FALSE,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_col_pattern(
  mapping = NULL,
  data = NULL,
  position = "stack",
  ...,
  width = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_crossbar_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  fatten = 2.5,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_ribbon_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  outline.type = "both"
)

geom_area_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "stack",
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE,
  ...,
  outline.type = "upper"
)

geom_density_pattern(
  mapping = NULL,
  data = NULL,
  stat = "density",
  position = "identity",
  ...,
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_polygon_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  rule = "evenodd",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_map_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  ...,
  map,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_sf_pattern(
  mapping = aes(),
  data = NULL,
  stat = "sf",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

geom_tile_pattern(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  linejoin = "mitre",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_violin_pattern(
  mapping = NULL,
  data = NULL,
  stat = "ydensity",
  position = "dodge",
  ...,
  draw_quantiles = NULL,
  trim = TRUE,
  scale = "area",
  na.rm = FALSE,
  orientation = NA,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Override the default connection between \code{geom_bar()} and
\code{stat_count()}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{width}{Bar width. By default, set to 90\% of the resolution of the data.}

\item{binwidth}{The width of the bins. Can be specified as a numeric value
or as a function that calculates width from unscaled x. Here, "unscaled x"
refers to the original x values in the data, before application of any
scale transformation. When specifying a function along with a grouping
structure, the function will be called once per group.
The default is to use the number of bins in \code{bins},
covering the range of the data. You should always override
this value, exploring multiple widths to find the best to illustrate the
stories in your data.

The bin width of a date variable is the number of days in each time; the
bin width of a time variable is the number of seconds.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}

\item{outlier.colour}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.color}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.fill}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.shape}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.size}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.stroke}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.alpha}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{notch}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, make a notched box plot. Notches are used to compare groups;
if the notches of two boxes do not overlap, this suggests that the medians
are significantly different.}

\item{notchwidth}{For a notched box plot, width of the notch relative to
the body (defaults to \code{notchwidth = 0.5}).}

\item{varwidth}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{fatten}{A multiplicative factor used to increase the size of the
middle bar in \code{geom_crossbar()} and the middle point in
\code{geom_pointrange()}.}

\item{outline.type}{Type of the outline of the area; \code{"both"} draws both the
upper and lower lines, \code{"upper"}/\code{"lower"} draws the respective lines only.
\code{"full"} draws a closed polygon around the area.}

\item{rule}{Either \code{"evenodd"} or \code{"winding"}. If polygons with holes are
being drawn (using the \code{subgroup} aesthetic) this argument defines how the
hole coordinates are interpreted. See the examples in \code{\link[grid:grid.path]{grid::pathGrob()}} for
an explanation.}

\item{map}{Data frame that contains the map coordinates.  This will
typically be created using \code{\link[ggplot2:fortify]{fortify()}} on a spatial object.
It must contain columns \code{x} or \code{long}, \code{y} or
\code{lat}, and \code{region} or \code{id}.}

\item{draw_quantiles}{If \code{not(NULL)} (default), draw horizontal lines
at the given quantiles of the density estimate.}

\item{trim}{If \code{TRUE} (default), trim the tails of the violins
to the range of the data. If \code{FALSE}, don't trim the tails.}

\item{scale}{if "area" (default), all violins have the same area (before trimming
the tails). If "count", areas are scaled proportionally to the number of
observations. If "width", all violins have the same maximum width.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Geom} object.
}
\description{
All geoms in this package are identical to their counterparts in ggplot2 except
that they can be filled with patterns.
}
\section{Pattern Arguments}{


Not all arguments apply to all patterns.

\describe{
\item{\strong{\code{pattern}}}{Pattern name string e.g. 'stripe' (default), 'crosshatch', 'point', 'circle', 'none'}
\item{\strong{\code{pattern_alpha}}}{ Alpha transparency for pattern. default: 1}
\item{\strong{\code{pattern_angle}}}{ Orientation of the pattern in degrees. default: 30}
\item{\strong{\code{pattern_aspect_ratio}}}{ Aspect ratio adjustment. }
\item{\strong{\code{pattern_colour}}}{ Colour used for strokes and points. default: 'black'}
\item{\strong{\code{pattern_density}}}{ Approximate fill fraction of the pattern. Usually in range [0, 1], but can be higher. default: 0.2}
\item{\strong{\code{pattern_filename}}}{ Image filename/URL. }
\item{\strong{\code{pattern_fill}}}{ Fill colour. default: 'grey80'}
\item{\strong{\code{pattern_fill2}}}{ Second fill colour. default: '#4169E1'}
\item{\strong{\code{pattern_filter}}}{ (Image scaling) filter. default: 'lanczos' }
\item{\strong{\code{pattern_frequency}}}{ Frequency. default: 0.1 }
\item{\strong{\code{pattern_gravity}}}{ Image placement. default: 'center' }
\item{\strong{\code{pattern_grid}}}{ Pattern grid type. default: 'square' }
\item{\strong{\code{pattern_key_scale_factor}}}{ Scale factor for pattern in legend. default: 1 }
\item{\strong{\code{pattern_linetype}}}{ Stroke linetype. default: 1}
\item{\strong{\code{pattern_option_1}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_option_2}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_option_3}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_option_4}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_option_5}}}{ Generic user value for custom patterns. }
\item{\strong{\code{pattern_orientation}}}{ 'vertical', 'horizontal', or 'radial'. default: 'vertical' }
\item{\strong{\code{pattern_res}}}{ Pattern resolution (pixels per inch). }
\item{\strong{\code{pattern_rot}}}{ Rotation angle (shape within pattern). default: 0 }
\item{\strong{\code{pattern_scale}}}{ Scale. default: 1}
\item{\strong{\code{pattern_shape}}}{ Plotting shape. default: 1}
\item{\strong{\code{pattern_size}}}{ Stroke line width. default: 1}
\item{\strong{\code{pattern_spacing}}}{ Spacing of the pattern as a fraction of the plot size. default: 0.05}
\item{\strong{\code{pattern_type}}}{ Generic control option }
\item{\strong{\code{pattern_subtype}}}{ Generic control option }
\item{\strong{\code{pattern_xoffset}}}{Offset the origin of the pattern. Range [0, 1]. default: 0.  Use this to slightly shift the origin of the pattern. For most patterns, the user should limit the offset value to be less than the pattern spacing.}
\item{\strong{\code{pattern_yoffset}}}{Offset the origin of the pattern. Range [0, 1]. default: 0.  Use this to slightly shift the origin of the pattern. For most patterns, the user should limit the offset value to be less than the pattern spacing.}
}
}

\examples{
  if (require("ggplot2")) {

    # 'stripe' pattern example
    df <- data.frame(level = c("a", "b", "c", 'd'), outcome = c(2.3, 1.9, 3.2, 1))
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = level),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      theme(legend.position = 'none') +
      labs(
        title    = "ggpattern::geom_col_pattern()",
        subtitle = "pattern = 'stripe'"
      )
    plot(gg)

    # 'pch' pattern example
    gg <- ggplot(mtcars, aes(as.factor(cyl), mpg)) +
      geom_violin_pattern(aes(fill = as.factor(cyl),
                              pattern_shape = as.factor(cyl)),
        pattern = 'pch',
        pattern_density = 0.3,
        pattern_angle = 0,
        colour  = 'black'
      ) +
      theme_bw(18) +
      theme(legend.position = 'none') +
      labs(
        title    = "ggpattern::geom_violin_pattern()",
        subtitle = "pattern = 'pch'"
      )
    plot(gg)

    # 'polygon_tiling' pattern example
    gg <- ggplot(mtcars) +
       geom_density_pattern(
         aes(
           x            = mpg,
           pattern_fill = as.factor(cyl),
           pattern_type = as.factor(cyl)
         ),
         pattern = 'polygon_tiling',
         pattern_key_scale_factor = 1.2
       ) +
       scale_pattern_type_manual(values = c("hexagonal", "rhombille",
                                  "pythagorean")) +
       theme_bw(18) +
       theme(legend.key.size = unit(2, 'cm')) +
       labs(
         title    = "ggpattern::geom_density_pattern()",
         subtitle = "pattern = 'polygon_tiling'"
       )
    plot(gg)
  }

}
