% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-nudge-dodge.R,
%   R/position-nudge-dodge2.R
\name{position_dodgenudge}
\alias{position_dodgenudge}
\alias{position_dodge_keep}
\alias{position_dodge2_keep}
\alias{position_dodge2nudge}
\title{Combined positions dodge and nudge}
\source{
\url{https://github.com/slowkow/ggrepel/issues/161}.
}
\usage{
position_dodgenudge(
  width = 1,
  preserve = c("total", "single"),
  x = 0,
  y = 0,
  direction = "none",
  kept.origin = "dodged"
)

position_dodge_keep(width = 1, preserve = c("total", "single"))

position_dodge2_keep(width = 1, preserve = c("total", "single"))

position_dodge2nudge(
  width = 1,
  preserve = c("total", "single"),
  padding = 0.1,
  reverse = FALSE,
  x = 0,
  y = 0,
  direction = "none",
  kept.origin = "dodged"
)
}
\arguments{
\item{width}{Dodging width, when different to the width of the individual
elements. This is useful when you want to align narrow geoms with wider
geoms. See the examples.}

\item{preserve}{Should dodging preserve the total width of all elements at a
position, or the width of a single element?.}

\item{x, y}{Amount of vertical and horizontal distance to move. A numeric
vector of length 1, or of the same length as rows there are in `data`,}

\item{direction}{One of "none", "split", "split.x" or "split.y". A value of
"none" replicates the behavior of [ggplot2::position_nudge]. At the moment
"split" changes the sign of the nudge at zero, which is suiatble for column
plots with negative slices.}

\item{kept.origin}{One of "original", "dodged" or "none".}

\item{padding}{Padding between elements at the same position. Elements are
shrunk by this proportion to allow space between them. Defaults to 0.1.}

\item{reverse}{If TRUE, will reverse the default stacking order. This is
useful if you're rotating both the plot and legend.}
}
\value{
A \code{"Position"} object.
}
\description{
`position_dodgenudge()` combines into one function the action of
[ggplot2::position_dodge] and [ggplot2::position_nudge] and
`position_dodge2nudge()` combines into one function the action of
[ggplot2::position_dodge2] and [ggplot2::position_nudge]. They are useful
when labelling plots such as grouped bars, columns, etc. and when adding
dodged to text labels linked to observations plotted without dodge. It can
replace other position functions as it is backwards compatible. Like all
other position functions in 'ggpp' and 'ggrepel' it preserves the initial
position to allow drawing of segments or arrow linking the original position
to the displaced one.
}
\details{
The appled dodge is identical to that by [ggplot2::position_dodge]
  while nudging is similar to that by [ggplot2::position_nudge].

There are two posible uses for these functions. First they can be used
to label dodged bars or boxplots. In this case, it is mandatory to use
the same argument to `width` when passing
`position_dodge()` to `geom_col()` and `position_dodgenudge()` to
`geom_text()` or `geom_label()` or their repulsive equivalents. Otherwise
the arrows or segments will fail to connect to the labels. In other words
jittering is computed twice. Jitter should be identical with the same
arguments as `position_dodgenudge()` as this last function simply call the
same code from package 'ggplot2'.

The second use is to dodge labels to be connected to elements that have not
been jittered. The return of original positions instead of the dodged
ones is achieved by passing `origin = "original"` instead of the default
of `origin = "dodged".`
}
\examples{
df <- data.frame(x1 = c(1, 2, 1, 3, -1),
                 x2 = c("a", "a", "b", "b", "b"),
                 grp = c("some long name", "other name", "some name",
                         "another name", "some long name"))

# Add labels to a horizontal column plot (stacked by default)
ggplot(data = df, aes(x1, x2, group = grp)) +
  geom_col(aes(fill = grp), width = 1,
           position = position_dodge()) +
  geom_vline(xintercept = 0) +
  geom_text(
    aes(label = grp),
    position = position_dodgenudge(x = 0.09, direction = "split"),
    angle = 90) +
  theme(legend.position = "none")

ggplot(data = df, aes(x2, x1, group = grp)) +
  geom_col(aes(fill = grp), width = 0.75,
           position = position_dodge(width = 0.75)) +
  geom_vline(xintercept = 0) +
  geom_text(aes(label = grp),
            position = position_dodgenudge(y = 0.1,
                                           direction = "split",
                                           width = 0.75)) +
  theme(legend.position = "none")

}
\seealso{
[ggplot2::position_nudge()], [ggrepel::position_nudge_repel()].

Other position adjustments: 
\code{\link{position_jitternudge}()},
\code{\link{position_nudge_center}()},
\code{\link{position_nudge_line}()},
\code{\link{position_nudge_to}()},
\code{\link{position_stacknudge}()}
}
\author{
Michał Krassowski, edited by Pedro J. Aphalo.
}
\concept{position adjustments}
