% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{summarylr}
\alias{summarylr}
\title{Summarizes a glm, adding a column of GLRT or Rao score P-values}
\usage{
summarylr(
  object,
  dispersion = NULL,
  correlation = FALSE,
  symbolic.cor = FALSE,
  ...,
  force = FALSE,
  debuglevel = level_warning,
  method = "LRT",
  keep.wald = FALSE
)
}
\arguments{
\item{object}{glm object; as obtained by calling \code{\link[stats:glm]{stats::glm}} or \code{\link[MASS:glm.nb]{MASS::glm.nb}}.}

\item{dispersion}{the dispersion parameter for the family used. Either a single numerical value or NULL (the default), when it is inferred from object (see \code{\link[stats:summary.glm]{stats::summary.glm}}).}

\item{correlation}{logical; if TRUE, the correlation matrix of the estimated parameters is returned and printed (see \code{\link[stats:summary.glm]{stats::summary.glm}}).}

\item{symbolic.cor}{logical; if TRUE, print the correlations in a symbolic form (see \code{\link[stats:symnum]{symnum}}) rather than as numbers (see \code{\link[stats:summary.glm]{stats::summary.glm}}).}

\item{...}{Additional arguments to be passed to \code{\link[stats:summary.glm]{stats::summary.glm}}}

\item{force}{logical; if TRUE, force computation of P-values in case of convergence problems.}

\item{debuglevel}{integer value; set to 0 (default) to disable warnings, 1 to enable warnings and 2 to enable warnings and notes.}

\item{method}{NULL or character vector of length 0, 1 or 2; may be code{"LRT"} or \code{"Rao"} or \code{c("LRT", "Rao")} to compute specified P-values.
You can set \code{method=NULL} to compute no additional P-values.}

\item{keep.wald}{logical; if TRUE, the standard Wald's P-values are kept in the output of \code{\link{print.summary.glmglrt}}. Even if keep.wald=FALSE, the standard wald P-values are not erased from the \code{summary.glmglrt} object. They are only hidden by \code{\link{print.summary.glmglrt}}.}
}
\value{
It returns a summary object of type \code{summary.glmglrt} that gets pretty printed by \code{link[glmglrt:print.summary.glmglrt]{print.summary.glmglrt}}
The return value is an S3 object compatible with \code{\link[stats:summary.glm]{stats::summary.glm}} but with an additional field \code{$extra} field having sub-fields.
\code{$extra$pvalues} is a numeric matrix with columns "LRT P-value" and/or "Rao P-value", containing the relevant P-values. As new columns may be added in future, you should rely on column names rather than column indexes. Only P-values of methods requested in the \code{method} parameter are stored in this matrix.
\code{$extra$debuglevel} is equal to the \code{debuglevel} passed to \code{summarylr}.
\code{$extra$keep.wald} is equal to the \code{keep.wald} passed to \code{summarylr}.
In case of convergence problems, the field \code{$extra$problem_of_convergence} will be added. It will be a character string with the value \code{"general"} (because model$converged = FALSE), \code{"all"} (because all coefficients have huge variances) or \code{"specific"} (because at least one coefficient has a huge variance). Other problem strings may be added in the future.
If \link[stats:glm]{weights} are specified in a way that make P-values invalid, the field \code{$extra$problem_weights} will be added as a character string describing the problem. Actually, the only known problem is \code{"non-constant"}.
}
\description{
\code{summarylr} is an improved summary function for standard glm (stats package) adding LRT or Rao score P-values
}
\details{
This function works the same as the standard \code{\link[stats]{summary.glm}} function but provides additionnal parameters
The core parameter \code{method="LRT"} makes \code{summarylr} adds a column \code{LRT P-value}
to the output. This P-value is computed by repeatdly fitting the model dropping
one coefficient at a time and using the \code{\link[stats:anova.glm]{anova.glm(test="Chisq")}} function to perform
generalized likelihood ratio test by approximation of the deviance difference
to a chi-square distribution. This provides P-values less biased than the standard Wald P-values
that \code{summary} provides. Moreover, this LRT method is consistent with the profile likelihood
confidence intervals that \code{\link[MASS:confint]{confint.glm}} provides.
The option \code{method="Rao"} generates Rao's score P-values. \code{method="Chisq"} is synonymous to \code{method="LRT"}.
For exhaustivity, the option \code{method="Wald"} (synonym "wald", "F") generates Wald's P-values.
Several methods can be used, e.g. \code{method=c("LRT","Rao")} computes both LRT and Rao P-values. New methods may be added in the future.

Extra parameters are passed-through to the \code{\link[stats]{summary.glm}} function.
}
\examples{
summarylr(glm(family="binomial", cbind(5,3)~1))
data(mtcars)
# do not properly converge (warnings)
mtcars$outcome = mtcars$disp > median(mtcars$disp)
mod=glm(family=binomial(log), data=mtcars,outcome ~ 0+qsec+wt,start=c(-0.1,0.3))
summarylr(mod) # warns that P-values are not computed because model did not converge
summarylr(mod, force=TRUE) # compute P-values anyway !
# also works with negative binomial models
summarylr(MASS::glm.nb(data=mtcars, I(cyl*gear) ~ 1+wt,link="sqrt"),test="LRT")
}
\seealso{
Other Extended GLM summary functions: 
\code{\link{override_summary}()},
\code{\link{print.summary.glmglrt}()}
}
\concept{Extended GLM summary functions}
