% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{richness}
\alias{richness}
\title{Species richness}
\format{
A data frame with 90 rows and 3 variables:
\describe{
  \item{Biomass}{a numeric vector giving the value of the biomass in the plots.}
  \item{pH}{a factor giving the soil pH level in the plots: "low", "mid", and "high".}
  \item{Species}{a numeric vector giving the number of plant species in the plots.}
}
}
\usage{
data(richness)
}
\description{
In these data the response is the species richness represented by a
count of the number of plant species on plots that have different biomass and
three different soil pH levels: low, mid, and high. See Crawley (2007, page 534).
}
\examples{
with(richness,{
  plot(Biomass, Species,
       col=apply(as.matrix(pH),1,function(x) switch(x,"low"="red","mid"="black","high"="blue")),
       pch=apply(as.matrix(pH),1,function(x) switch(x,"low"=15,"mid"=16,"high"=17)))
  legend(8.2, 43, legend=c("low","mid","high"), col=c("red","black","blue"),
         pch=c(15,16,17), bty="n", cex=0.8, title="pH level")
})
}
\references{
Crawley, M.J. (2007) \emph{The R Book}. John Wiley & Sons, Chichester.
}
\keyword{datasets}
