% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{swimmers}
\alias{swimmers}
\title{Self diagnozed ear infections in swimmers}
\format{
A data frame with 287 rows and 5 variables:
\describe{
  \item{frequency}{a factor giving the recruit's perception of whether he or she is a frequent swimmer: "frequent" and "occasional".}
  \item{location}{a factor giving the recruit's usually chosen swimming location: "beach" and "non-beach".}
  \item{age}{a factor giving the recruit's age range: "15-19", "20-24" and "25-29".}
  \item{gender}{a factor giving the recruit's gender: "male" and "female".}
  \item{infections}{a numeric vector giving the number of self diagnozed
        ear infections that were reported by the recruit.}
}
}
\usage{
data(swimmers)
}
\description{
The data come from the Pilot Surf/Health
Study of NSW Water Board performed in 1990 on 287
recruits. The objective of the study was to determine,
in particular, whether beach swimmers run a greater
risk of contracting ear infections than non-beach swimmers.
See Hand et al. (1994. page 266).
}
\examples{
boxplot(infections ~ frequency, data=subset(swimmers,location=="non-beach"),
        at=c(1:2)-0.2, col="yellow", boxwex=0.25, outline=FALSE, xaxt="n")
boxplot(infections ~ frequency, data=subset(swimmers,location=="beach"), add=TRUE,
        at=c(1:2)+0.2, col="blue", boxwex=0.25, outline=FALSE, xaxt="n")
axis(1, at=1:2, labels=levels(swimmers$frequency))
legend(0.2, 6.3, legend=c("non-beach","beach"), fill=c("yellow","blue"),
        bty="n", cex=0.7, x.intersp=0.2, y.intersp=1)
}
\references{
Hand, D.J. and Daly, F. and Lunn, A.D. and McConway, K.J. and Ostrowsky, E. (1994)
\emph{A Handbook of Small Data Sets}, Chapman and Hall, London.

Vanegas, L.H. and Rondon, L.M. (2020) A data transformation to deal with
constant under/over-dispersion in binomial and poisson regression models. \emph{Journal
of Statistical Computation and Simulation} 90, 1811-1833.
}
\keyword{datasets}
