% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{Ops.gmpoly}
\alias{Ops.gmpoly}
\title{Arithmetic operators for multivariate polynomials}
\usage{
\method{Ops}{gmpoly}(e1, e2 = NULL)
}
\arguments{
\item{e1, e2}{for an unary operator, only \code{e1} must be given, a 
\code{\link{gmpoly}} object; for a binary operator, at least one of 
\code{e1} and \code{e2} must be a \code{\link{gmpoly}} object, and the 
other must a \code{\link{gmpoly}} object as well or a scalar; the power
operator (\code{^}) is an exception: one can only raise a 
\code{\link{gmpoly}} object to a positive integer power}
}
\value{
A \code{\link{gmpoly}} object.
}
\description{
Arithmetic operators for multivariate polynomials
}
\examples{
library(gmpoly)
pol <- gmpoly("4 x^(2, 1, 1) + 1/2 x^(0,1,0)")
+pol
-pol
2 * pol
pol / 2
pol + 5
pol - 5
pol^2
pol1 <- gmpoly("2 x^(1,1) - 5/3 x^(0,1)")
pol2 <- gmpoly("-2 x^(1,1) + 3 x^(2,1)")
pol1 + pol2
pol1 * pol2
pol1 == pol2
pol1 != pol2
}
