% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_lock.R
\name{model_lock}
\alias{model_lock}
\alias{model_unlock}
\title{Model lock/unlock}
\usage{
model_lock(folder=".", file=".lock", timeout1=NULL, timeout2=NULL,
check_interval=1, oncluster=TRUE)
model_unlock(id,folder=".",file=".lock",oncluster=TRUE)
}
\arguments{
\item{folder}{model folder}

\item{file}{file name of the lock file containing the process queue}

\item{timeout1}{Time in hours the top process in the queue is allowed to run
before the current process is stopped.}

\item{timeout2}{Time in hours the processed is allowed to wait in the queue
before it is stopped}

\item{check_interval}{Time in seconds between checking the current position
in the queue.}

\item{oncluster}{a logical indicating whether the script is run on cluster
or not. On windows a lock file is created, which does not prevent
simulatneous access to the model. On the cluster the system command 'mkdir'
is used to prevent simultaneous access. This atomicity of check-and-create
is ensured at the operating system kernel level.}

\item{id}{process id as returned by model_lock.}
}
\value{
model_lock returns the process id which is needed (only on Windows)
to identify the process in model_unlock.
}
\description{
Functions that indicate whether a model folder is currently locked by
another process or not. This helps to prevent unintended interactions
between processes.
}
\examples{
#lock folder
id <- model_lock(tempdir())

#unlock folder
model_unlock(id,tempdir())
}
\seealso{
\code{\link{check_config}}
}
\author{
Jan Philipp Dietrich, David Klein
}
