% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sources.R
\name{RepoSource}
\alias{RepoSource}
\title{RepoSource Object}
\usage{
RepoSource(
  repoName = NULL,
  tagName = NULL,
  commitSha = NULL,
  branchName = NULL,
  dir = NULL,
  projectId = NULL
)
}
\arguments{
\item{repoName}{Name of the Cloud Source Repository}

\item{tagName}{Regex matching tags to build}

\item{commitSha}{Explicit commit SHA to build}

\item{branchName}{Regex matching branches to build e.g. ".*"}

\item{dir}{Directory, relative to the source root, in which to run the build}

\item{projectId}{ID of the project that owns the Cloud Source Repository}
}
\value{
RepoSource object
}
\description{
RepoSource Object
}
\details{
Location of the source in a Google Cloud Source Repository.

Only one of commitSha, branchName or tagName are allowed.

If you want to use GitHub or BitBucket repos, you need to setup mirroring
  them via Cloud Source Repositories https://source.cloud.google.com/
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
\dontrun{

my_repo <- cr_build_source(
  RepoSource("github_markedmondson1234_googlecloudrunner",
    branchName = "master"
  )
)

build <- cr_build(
  cr_build_yaml(
    steps =
      cr_buildstep("gcloud", c("-c", "ls -la"),
        entrypoint = "bash",
        dir = ""
      )
  ),
  source = my_repo
)
}
}
\seealso{
Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
