% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml.R
\name{cr_build_yaml_artifact}
\alias{cr_build_yaml_artifact}
\title{Add an artifact for cloudbuild.yaml}
\usage{
cr_build_yaml_artifact(paths, bucket_dir = NULL, bucket = cr_bucket_get())
}
\arguments{
\item{paths}{Which files from the working directory to upload to cloud storage once the build is finished.  Can use globs but see details of \link{cr_build_artifacts} on how that affects downloads}

\item{bucket_dir}{The directory in the bucket the files will be uploaded to}

\item{bucket}{the bucket to send to}
}
\description{
Add artifact objects to a build
}
\examples{
\dontrun{
cr_project_set("my-project")
r <- "write.csv(mtcars,file = 'artifact.csv')"
cr_build_yaml(
  steps = cr_buildstep_r(r),
  artifacts = cr_build_yaml_artifact("artifact.csv", bucket = "my-bucket")
)
}
}
\seealso{
Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_artifacts}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
