% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jwt-requests.R
\name{cr_jwt_create}
\alias{cr_jwt_create}
\alias{cr_jwt_token}
\alias{cr_jwt_with_httr}
\alias{cr_jwt_with_curl}
\alias{cr_jwt_async}
\title{Create a JSON Web Token (JWT) from your service client and call Google services}
\usage{
cr_jwt_create(the_url, service_json = Sys.getenv("GCE_AUTH_FILE"))

cr_jwt_token(signed_jwt, the_url)

cr_jwt_with_httr(req, token)

cr_jwt_with_curl(h = curl::new_handle(), token)

cr_jwt_async(urls, token, ...)
}
\arguments{
\item{the_url}{The URL of the service you want to call}

\item{service_json}{The account service key JSON that will be used to generate the JWT}

\item{signed_jwt}{A JWT created from \link{cr_jwt_create}}

\item{req}{A \code{httr} request to the service running on \code{the_url}, using httr verbs such as \link[httr]{GET}}

\item{token}{The token created via \link{cr_jwt_token}}

\item{h}{A curl handle such as set with \link[curl]{new_handle}}

\item{urls}{URLs to request asynchronously}

\item{...}{Other arguments passed to \link[curl]{new_handle}}
}
\description{
This can be used to call authenticated services such as Cloud Run.
}
\details{
For certain Google services a JWT is needed to authenticate access, which is distinct from OAuth2.  An example of this is authenticated Cloud Run such as deployed when using \link{cr_run} and parameter \code{allowUnauthenticated = FALSE}.  These functions help you call your services by generating the JWT from your service account key.

The token is set to expire in 1 hour, so it will need refreshing before then by calling this function again.
}
\examples{
\dontrun{

# The private authenticated access only Cloud Run service
the_url <- "https://authenticated-cloudrun-ewjogewawq-ew.a.run.app/"

# creating the JWT and token
jwt <- cr_jwt_create(the_url)
token <- cr_jwt_token(jwt, the_url)

# call Cloud Run app using token with any httr verb
library(httr)
res <- cr_jwt_with_httr(
  GET("https://authenticated-cloudrun-ewjogewawq-ew.a.run.app/hello"),
  token
)
content(res)

# call Cloud Run app with curl - you can pass in a curl handle
library(curl)
h <- new_handle()
handle_setopt(h, customrequest = "PUT")
handle_setform(h, a = "1", b = "2")
h <- cr_jwt_with_curl(h, token = token)
r <- curl_fetch_memory("https://authenticated-cloudrun-ewjogewawq-ew.a.run.app/hello", h)
cat(rawToChar(r$content))

# use curls multi-asynch functions
many_urls <- paste0(
  "https://authenticated-cloudrun-ewjogewawq-ew.a.run.app/hello",
  paste0("?param="), 1:6
)
cr_jwt_async(many_urls, token = token)
}

}
\seealso{
\href{https://cloud.google.com/run/docs/authenticating/service-to-service}{Service-to-service authentication on GCP}

Other Cloud Run functions: 
\code{\link{cr_plumber_pubsub}()},
\code{\link{cr_run_email}()},
\code{\link{cr_run_get}()},
\code{\link{cr_run_list}()},
\code{\link{cr_run_schedule_http}()},
\code{\link{cr_run}()}
}
\concept{Cloud Run functions}
