% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_accept.R
\name{prob_accept}
\alias{prob_accept}
\title{Probability of acceptance for grab sampling scheme}
\usage{
prob_accept(c, r, t, mu, distribution, K, m, sd)
}
\arguments{
\item{c}{acceptance number}

\item{r}{number of primary increments in a grab sample or grab sample size}

\item{t}{number of grab samples}

\item{mu}{location parameter (mean log) of the Lognormal and Poisson-lognormal distributions on the log10 scale}

\item{distribution}{what suitable microbiological distribution we have used such as  \code{'Poisson gamma'} or \code{'Lognormal'}or \code{'Poisson lognormal'}}

\item{K}{dispersion parameter of the Poisson gamma distribution (default value 0.25)}

\item{m}{microbiological limit with default value zero, generally expressed as number of microorganisms in specific sample weight}

\item{sd}{standard deviation of the lognormal and Poisson-lognormal distributions on the log10 scale (default value 0.8)}
}
\value{
Probability of acceptance
}
\description{
This function calculates the overall probability of acceptance for given microbiological distribution such as lognormal.
}
\details{
Based on the food safety literature, for given values of \code{c}, \code{r} and \code{t}, the probability of detection in a primary increment is given by, \eqn{p_d=P(X > m)=1-P_{distribution}(X \le m|\mu ,\sigma)} and acceptance probability in \code{t} selected sample is given by \eqn{P_a=P_{binomial}(X \le c|t,p_d)}.

If Y be the sum of correlated and identically distributed lognormal random variables X, then the approximate distribution of Y is lognormal
distribution with mean \eqn{\mu_y}, standard deviation \eqn{\sigma_y} (see \href{https://doi.org/10.1109/ICC.2006.255040}{Mehta et al (2006)}) where \eqn{E(Y)=mE(X)} and \eqn{V(Y)=mV(X)+cov(X_i,X_j)} for all \eqn{i \ne j =1 \cdots r}.

The parameters \eqn{\mu_y} and \eqn{\sigma_y} of the grab sample unit Y is given by,
\deqn{\mu_y =\log_{10}{(E[Y])} - {{\sigma_y}^2}/2 \log_e(10) }
(see \href{https://doi.org/10.1016/j.foodcont.2013.02.021}{Mussida et al (2013)}). For this package development, we have used fixed \eqn{\sigma_y} value with default value 0.8.
}
\examples{
  c <-  0
  r <-  25
  t <-  30
  mu <-  -3
  distribution <- 'Poisson lognormal'
  prob_accept(c, r, t, mu, distribution)
}
\references{
\itemize{
\item Mussida, A., Vose, D. & Butler, F. Efficiency of the sampling plan for {C}ronobacter spp. assuming a Poisson lognormal distribution of the bacteria in powder infant formula and the implications of assuming a fixed within and between-lot variability, Food Control, Elsevier, 2013 , 33 , \href{https://doi.org/10.1016/j.foodcont.2013.02.021}{174-185}.
\item Mehta, N.B, Molisch, A.F, Wu, J, &  Zhang, J., 'Approximating the Sum of Correlated Lognormal or, Lognormal-Rice Random Variables,' 2006 IEEE International Conference on Communications, Istanbul, 2006, pp. \href{https://doi.org/10.1109/ICC.2006.255040}{1605-1610}.
}
}
