% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_density.R
\name{plot_density}
\alias{plot_density}
\title{Plot density distribution of data.}
\usage{
plot_density(
  data,
  ycol,
  group,
  linethick = 1,
  c_alpha = 0.2,
  ColPal = "all_grafify",
  ColSeq = TRUE,
  ColRev = FALSE,
  TextXAngle = 0,
  fontsize = 20,
  Group,
  alpha,
  ...
)
}
\arguments{
\item{data}{a data table e.g. data.frame or tibble.}

\item{ycol}{name of the column containing the quantitative variable whose density distribution is to be plotted.}

\item{group}{name of the column containing a categorical grouping variable}

\item{linethick}{thickness of symbol border, default set to 1.}

\item{c_alpha}{fractional opacity of filled colours under the curve, default set to 0.2 (i.e. 20\% opacity).}

\item{ColPal}{grafify colour palette to apply, default "all_grafify"; alternatives: "okabe_ito", "bright", "pale", "vibrant", "contrast", "muted" "dark", "light".}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour choice, default F (FALSE); can be set to T (TRUE).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{Group}{deprecated old argument for \code{group}; retained for backward compatibility.}

\item{alpha}{deprecated old argument for \code{c_alpha}; retained for backward compatibility.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_density}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, \code{ycol} of quantitative variable and a categorical grouping variable (\code{group}), if available, and plots a density graph using \code{\link{geom_density}}).
}
\details{
Note that the function requires the quantitative Y variable first, and groups them based on an X variable. The group variable is mapped to the \code{fill} and \code{colour} aesthetics in \code{geom_density}.
Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments. Colours available can be seen quickly with \code{\link{plot_grafify_palette}}.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.
}
\examples{
plot_density(data = data_t_pratio, 
ycol = log(Cytokine), group = Genotype)

#with faceting
plot_density(data = data_cholesterol, 
ycol = Cholesterol, group = Treatment, 
fontsize = 10)+facet_wrap("Treatment")
}
