% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_qqmodel.R
\name{plot_qqmodel}
\alias{plot_qqmodel}
\title{Plot quantile-quantile (QQ) graphs from residuals of linear models.}
\usage{
plot_qqmodel(Model, symsize = 2.5, symthick = 1, s_alpha = 1, fontsize = 20)
}
\arguments{
\item{Model}{name of a saved model generated by \code{simple_model} or \code{mixed_model}.}

\item{symsize}{size of symbols, default set to 3.}

\item{symthick}{thickness of symbol border, default set to 1.}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a linear model (simple or mixed effects) and plots a QQ graph after running \code{rstudent} from \code{\link[stats]{rstudent}} to generate a table of studentized model residuals on an ordinary (\code{\link{simple_model}}),  mixed model (\code{\link{mixed_model}} or \code{\link{mixed_model_slopes}}. The graph plots studentized residuals from the model (sample) on Y axis & Theoretical quantiles on X axis.
}
\details{
The function uses \code{\link{ggplot2}[geom_qq]} and \code{\link{ggplot2}[geom_qq_line]} geometries. Symbols receive "ok_orange" colour by default.
}
\examples{
#Basic usage
m1 <- simple_model(data = data_2w_Festing, 
Y_value = "GST", 
Fixed_Factor = c("Treatment", "Strain"))
plot_qqmodel(m1)

}
