% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_graphab_linkset_cost.R
\name{get_graphab_linkset_cost}
\alias{get_graphab_linkset_cost}
\title{Get cost values associated with a linkset in a Graphab project}
\usage{
get_graphab_linkset_cost(proj_name, linkset, proj_path = NULL)
}
\arguments{
\item{proj_name}{A character string indicating the Graphab project name.
The project name is also the name of the project directory in which the
file proj_name.xml will be created.}

\item{linkset}{(optional, default=NULL) A character string indicating the
name of the link set used to create the graph. Link sets can be created
with \code{\link{graphab_link}}.}

\item{proj_path}{(optional) A character string indicating the path to the
directory that contains the project directory. It should be used when the
project directory is not in the current working directory. Default is NULL.
When 'proj_path = NULL', the project directory is equal to \code{getwd()}.}
}
\value{
The function returns a data.frame with the cost values corresponding
to every raster code value.
}
\description{
The function extracts the cost values associated with a
linkset in a Graphab project
}
\examples{
\dontrun{
proj_name <- "grphb_ex"
get_graphab_linkset_cost(proj_name = proj_name,
               linkset = "lkst1")
}
}
\author{
P. Savary
}
