% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-methods.R
\name{draw.mgcv_smooth}
\alias{draw.mgcv_smooth}
\title{Plot basis functions}
\usage{
\method{draw}{mgcv_smooth}(
  object,
  legend = FALSE,
  use_facets = TRUE,
  labeller = NULL,
  xlab,
  ylab,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  ...
)
}
\arguments{
\item{object}{an object, the result of a call to \code{\link[=basis]{basis()}}.}

\item{legend}{logical; should a legend by drawn to indicate basis functions?}

\item{use_facets}{logical; for factor by smooths, use facets to show the
basis functions for each level of the factor? If \code{FALSE}, a separate ggplot
object will be created for each level and combined using
\code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}. \strong{Currently ignored}.}

\item{labeller}{a labeller function with which to label facets. The default
is to use \code{\link[ggplot2:labellers]{ggplot2::label_both()}}.}

\item{xlab}{character or expression; the label for the x axis. If not
supplied, a suitable label will be generated from \code{object}.}

\item{ylab}{character or expression; the label for the y axis. If not
supplied, a suitable label will be generated from \code{object}.}

\item{title}{character or expression; the title for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{subtitle}{character or expression; the subtitle for the plot. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{caption}{character or expression; the plot caption. See
\code{\link[ggplot2:labs]{ggplot2::labs()}}.}

\item{...}{arguments passed to other methods. Not used by this method.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Plots basis functions using ggplot2
}
\examples{
load_mgcv()
\dontshow{set.seed(42)}
df <- gamSim(4, n = 400, verbose = FALSE)

bf <- basis(s(x0), data = df)
draw(bf)

bf <- basis(s(x2, by = fac, bs = 'bs'), data = df)
draw(bf)
}
\author{
Gavin L. Simpson
}
