% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-array-magick.R
\docType{data}
\name{grid.pattern_magick}
\alias{grid.pattern_magick}
\alias{names_magick}
\alias{names_magick_intensity}
\alias{names_magick_stripe}
\title{Magick patterned grobs}
\format{
An object of class \code{character} of length 54.

An object of class \code{character} of length 21.

An object of class \code{character} of length 19.
}
\usage{
grid.pattern_magick(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  type = "hexagons",
  fill = "grey20",
  scale = 1,
  filter = "box",
  alpha = gp$alpha \%||\% NA_real_,
  aspect_ratio = 1,
  key_scale_factor = 1,
  res = getOption("ggpattern_res", 72),
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)

names_magick

names_magick_intensity

names_magick_stripe
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{type}{Magick pattern types.  \code{names_magick}, \code{names_magick_intensity}, and
\code{names_magick_stripe} are character vectors of supported \code{type} values
plus subsets for shaded intensity and stripes.}

\item{fill}{Fill colour}

\item{scale}{Extra scaling}

\item{filter}{Filter to use when scaling. \code{magick::filter_types()} returns a vector of supported values.}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{aspect_ratio}{Override aspect ratio}

\item{key_scale_factor}{Additional scale factor for legend}

\item{res}{Assumed resolution (in pixels per graphic device inch) to use when creating array pattern.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_magick()} draws a \code{imagemagick} pattern onto the graphic device.
\code{names_magick}, \code{names_magick_intensity}, and
\code{names_magick_stripe} are character vectors of supported \code{type} values
plus subsets for shaded intensity and stripes.
}
\examples{
  if (require("magick")) {
    x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
    grid.pattern_magick(x_hex, y_hex, type="octagons", fill="blue", scale=2)
  }

  # supported magick pattern names
  print(names_magick)
}
\seealso{
The \code{imagemagick} documentation \url{http://www.imagemagick.org/script/formats.php} for more information.
}
\keyword{datasets}
