% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.r
\name{hql_create}
\alias{hql_create}
\alias{hql_create_file}
\alias{hql_create_group}
\title{Create HDF Files, Datasets or Attribute}
\usage{
hql_create_file(file, overwrite = FALSE, parallel = FALSE)

hql_create_group(group, overwrite = FALSE)
}
\arguments{
\item{file}{The HDF file to create.}

\item{overwrite}{If \code{TRUE}, overwrite existing file, group,
attribute, or dataset.}

\item{parallel}{If \code{TRUE}, use parallel capabilities.}

\item{group}{The group to create.}
}
\description{
Create HDF files and groups.
}
\section{Functions}{
\itemize{
\item \code{hql_create_file}: Create HDF file.

\item \code{hql_create_group}: Create HDF group.
}}

\examples{
if(hql_is_loaded()) {
  tf = tempfile(fileext = ".h5")
  hql_create_file(tf)

  hql_use_file(tf)
  hql_create_group("group1")

  hql_close_file(tf)
}

}
