% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_bivar.R
\name{hermite_estimator_bivar}
\alias{hermite_estimator_bivar}
\title{A class to sequentially estimate bivariate pdfs, cdfs and nonparametric 
correlations}
\usage{
hermite_estimator_bivar(N = 30, standardize = TRUE, exp_weight_lambda = NA)
}
\arguments{
\item{N}{An integer between 0 and 75. The Hermite series based estimator
is truncated at N+1 terms.}

\item{standardize}{A boolean value. Determines whether the observations are
standardized, a transformation which often improves performance.}

\item{exp_weight_lambda}{A numerical value between 0 and 1. This parameter
controls the exponential weighting of the Hermite series based estimator.
If this parameter is NA, no exponential weighting is applied.}
}
\value{
An S3 object of class hermite_estimator_bivar, with methods for
density function and distribution function estimation along with Spearman's
rank correlation estimation.
}
\description{
This method constructs an S3 object with methods for nonparametric estimation
of bivariate pdfs and cdfs along with nonparametric correlations.
}
\details{
The hermite_estimator_bivar class allows the sequential or one-pass batch
estimation of the full bivariate probability density function and cumulative 
distribution function along with the Spearman's rank correlation 
coefficient. It is well suited to streaming data (both stationary and 
non-stationary) and to efficient estimation in the context of massive or 
distributed data sets. Indeed,estimators constructed on different subsets 
of a distributed data set can be consistently merged.
}
\examples{
hermite_est <- hermite_estimator_bivar(N = 30, standardize = TRUE)
}
\author{
Michael Stephanou <michael.stephanou@gmail.com>
}
