% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.hero_bspline.R
\name{plot.hero_bspline}
\alias{plot.hero_bspline}
\title{Plot a \code{hero_bspline} object}
\usage{
\method{plot}{hero_bspline}(x, nderiv = 0L, type = "l", kcol = NULL, ...)
}
\arguments{
\item{x}{An object of class \code{hero_bspline} to be plotted.}

\item{nderiv}{An integer value specifying the derivative order of the B-splines.  The default is 0.}

\item{type}{character string (length 1 vector) or vector of 1-character
    strings indicating the type of plot for each
    column of \code{y}, see \code{\link[graphics]{plot}} for all possible
    \code{type}s.  The first character of \code{type}
    defines the first plot, the second character the second, etc.
    Characters in \code{type} are cycled through; e.g., \code{"pl"}
    alternately plots points and lines.}

\item{kcol}{Color for vertical lines drawn at interior knots.  Default is \code{NULL}, meaning no lines are drawn.}

\item{...}{Additional graphical parameters passed to \code{\link[graphics]{matplot}} function.}
}
\description{
Plots basis functions specified by results of \code{\link{bspline}}.
}
\examples{
x = bspline(nbasis = 10, extend = FALSE)
plot(x)
plot(x, nderiv = 1)
plot(x, kcol = "grey") # plot vertical lines at knots

# extend knots passed rangeval
x2 = bspline(nbasis = 10, extend = TRUE)
plot(x2, kcol = "grey")

# compare to plot.fd
x3 = fda::create.bspline.basis(nbasis = 10)
par(mfrow = c(2, 1))
plot(x, kcol = "grey")
title("plot.hero_bspline")
plot(x3)
title("plot.fd")
}
\seealso{
\code{\link{bspline}}
}
