% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{surv_quantile}
\alias{surv_quantile}
\title{Survival quantiles}
\usage{
surv_quantile(x, probs = 0.5, t, surv_cols, by)
}
\arguments{
\item{x}{A \code{data.table} or \code{data.frame}.}

\item{probs}{A numeric vector of probabilities with values in \code{[0,1]}.}

\item{t}{A character scalar of the name of the time column.}

\item{surv_cols}{A character vector of the names of columns containing
survival curves.}

\item{by}{A character vector of the names of columns to group by.}
}
\value{
A \code{data.table} of quantiles of each survival curve in
\code{surv_cols} by each group in \code{by}.
}
\description{
Compute quantiles from survival curves.
}
\examples{
library("data.table")
t <- seq(0, 10, by = .01)
surv1 <- seq(1, .3, length.out = length(t))
surv2 <- seq(1, .2, length.out = length(t))
strategies <- c("Strategy 1", "Strategy 2")
surv <- data.table(strategy = rep(strategies, each = length(t)),
                   t = rep(t, 2), 
                   surv = c(surv1, surv2))
surv_quantile(surv, probs = c(.4, .5), t = "t",
              surv_cols = "surv", by = "strategy")
}
