% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highDmean.R
\docType{package}
\name{highDmean}
\alias{highDmean}
\title{highDmean: A package for testing of equal mean for two-sample high dimensional data}
\description{
This package is an implementation of the high-dimensional two-sample test
proposed by Zhang and Wang (2020) "Result consistency of high dimensional two-sample tests
applied to gene ontology terms with gene sets". It also implements the SKK test proposed by
Srivastava, Katayama, and Kano (2013) "A two sample test in high dimensional data."
These tests are particularly suitable for high dimensional data from two populations
for which the classical multivariate Hotelling's T-square test fails due to sample sizes smaller than
dimensionality. In this case, the ZWL and ZWLm tests proposed by Zhang and Wang (2020), referred to as
zwl_test() in this package, provide a reliable and powerful test.
}
\section{highDmean functions}{

The function \code{zwl_test()} conducts the ZWL and ZWLm test of equal mean for two-sample high dimensional data provided in
matrices of dimension \code{n} by \code{p} and \code{m}
by \code{p}, which are random samples from two populations. It
returns the value of test statistic and p-value under the null hypothesis of equal means.
The \code{SKK_test()} performs the SKK test and returns the value of test statistic and p-value.
The \code{buildData()} function generates simulated high-dimensional data in the two-population setting
with specified sample sizes, numbers of components, covariance structure, etc., and
the functions \code{zwl_sim()} and \code{SKK_sim()}
return test statistic values and p-values for lists of simulated data sets generated by \code{buildData()}.
}

