% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{index}
\alias{index}
\alias{index.data.frame}
\alias{index.matrix}
\alias{index.double}
\alias{index.numeric}
\alias{index.integer}
\alias{index64}
\alias{index64.data.frame}
\alias{index64.matrix}
\alias{index64.double}
\alias{index64.integer}
\alias{index64.numeric}
\alias{index64.integer64}
\alias{index64.character}
\alias{index64.bitstring}
\title{Index positions to a Hilbert Curve}
\usage{
index(x, ..., n = 10L)

\method{index}{data.frame}(x, ..., n, coords = c(1, 2), attach = TRUE)

\method{index}{matrix}(x, ..., n, coords = c(1, 2), attach = TRUE)

\method{index}{double}(x, y, ..., n)

\method{index}{numeric}(x, y, ..., n)

\method{index}{integer}(x, y, ..., n)

index64(x, ..., n = 10L)

\method{index64}{data.frame}(x, ..., n, coords = c(1, 2), attach = TRUE)

\method{index64}{matrix}(x, ..., n, coords = c(1, 2), attach = TRUE)

\method{index64}{double}(x, y, ..., n)

\method{index64}{integer}(x, y, ..., n)

\method{index64}{numeric}(x, y, ..., n)

\method{index64}{integer64}(x, y, ..., n)

\method{index64}{character}(x, y, ..., n)

\method{index64}{bitstring}(x, y, ..., n)
}
\arguments{
\item{x}{One of: Numeric vector, \code{data.frame}, or \code{matrix}.
If a numeric vector, then it corresponds to the rows
of a position.}

\item{...}{Unused.}

\item{n}{Exponent to the dimensions of the underlying grid. The Hilbert
Curve indices are based on a \verb{2^n x 2^n} grid. This number
must be less than 15 due to the 32-bit implementation of R.}

\item{coords}{Column names or indices of a \code{data.frame}/\code{matrix} that
contain the position coordinates.}

\item{attach}{If \code{TRUE}, adds the indices as a new column to the given
\code{data.frame}/\code{matrix}. If \code{x} is a \code{data.frame}, then the
column is named \code{h}; otherwise, it is an unnamed column at
the end of the matrix.}

\item{y}{Numeric vector.
Corresponds to the columns of a position.}
}
\value{
An \code{integer} vector of Hilbert indices, or when \code{attach} is \code{TRUE},
the original object (\code{data.frame} or \code{matrix}) with a new \code{integer}
column (\code{h} for \code{data.frame}) containing the Hilbert indices. When
\code{n} is greater than 15, the vector is of type \code{bit64::integer64}.
}
\description{
Index positions to a Hilbert Curve
}
