% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RCode.R
\name{hindexcalculator}
\alias{hindexcalculator}
\title{H-Index Calculator using Data from a Web of Science (WoS) Citation Report}
\usage{
hindexcalculator(readcsv, hx, date)
}
\arguments{
\item{readcsv}{- The read.csv function that will locate the citation report of interest}

\item{hx}{- The h-index of interest. Can be any positive integer or "c" (without quotations) for cumulative h-index}

\item{date}{- The last year of interest plus 1. For instance, if the citation report includes the year 2015 but you want h(10) not incuding 2015, therefore 2005-2014, you would enter 2015 for this argument}
}
\description{
H-Index Calculator using Data from a Web of Science (WoS) Citation Report
}
\examples{
#calculate the h(10) of the Brigham and Women's Hospital - Department of Anesthesia
 data(BWHCitationReport)
 readcsv <- BWHCitationReport
 hx <- 10
 date <- 2015

 hindexcalculator(readcsv, hx, date)
}

