% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{search_person_by_parameters}
\alias{search_person_by_parameters}
\title{Search person by name and date of birth}
\usage{
search_person_by_parameters(
  first_name = NULL,
  last_name = NULL,
  birth_date = NULL,
  ignore_diacritics = TRUE,
  token = Sys.getenv("HLIDAC_TOKEN")
)
}
\arguments{
\item{first_name}{Person's first name}

\item{last_name}{Person's last name}

\item{birth_date}{Person's date of birth (in YYYY-MM-DD format)}

\item{ignore_diacritics}{Parameter indicating whether diacritics in names should be ignored (boolean)}

\item{token}{Access token}
}
\value{
data.frame with found persons with the following columns:
- jmeno: given name
- prijmeni: surname
- narozeni: date of birth
- nameId: person's ID
- profile: URL of profile at hlidacstatu.cz
- titulPred: academic titles written before person's name
- titulPo: academic titles written after person's name
}
\description{
Search person by name and date of birth
}
\examples{
\dontrun{
search_person_by_parameters(first_name = "Miroslav", last_name = "Kalousek",
birth_date = "1960-12-17")
}
}
\seealso{
\url{https://www.hlidacstatu.cz/swagger/index.html}

\url{https://www.hlidacstatu.cz/api/v1/doc}

Other Persons: 
\code{\link{get_person_social}()},
\code{\link{get_person}()},
\code{\link{search_person}()}
}
\concept{Persons}
